﻿<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
    xmlns:xbrli='http://www.xbrl.org/2003/instance'
    xmlns:iso4217='http://www.xbrl.org/2003/iso4217'
    xmlns:ifrs-gp='http://xbrl.iasb.org/int/fr/ifrs/gp/2004-01-15'
    xmlns='http://www.xbrl.org/2003/instance' >
<xsl:output method='xml' indent='yes' />
<xsl:decimal-format name='base' decimal-separator='.' grouping-separator=',' minus-sign='-' />
<xsl:template match='/'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
   <style>
      body {font-family:Arial;font-size:10pt;font-weight:normal;color:black;text-align:left;vertical-align:top;background-color:white;}
      h1 {font-family:Arial;font-size:14pt;font-weight:bold;color:navy;border-bottom:Navy thick solid;text-align:center;vertical-align:top;}
      .Heading {font-family:Arial;font-size:10pt;font-weight:bold;color:black;text-align:left;text-indent:-20px;padding-left:20px;}
      .SectionHeading {font-family:Arial;font-size:10pt;font-weight:normal;color:black;text-align:left;text-indent:-20px;padding-left:20px;}
      .SubSectionHeading {font-family:Arial;font-size:10pt;font-weight:bold;color:black;text-align:left;vertical-align:bottom;padding-top:15px;}
      .Label {font-family:Arial;font-size:10pt;font-weight:normal;color:black;text-align:left;text-indent:-20px;padding-left:20px;}
      .Note {font-family:Arial;font-size:10pt;font-weight:normal;color:black;text-align:right;padding-left:20px;}
      .Value {font-family:Arial;font-size:10pt;font-weight:normal;color:black;text-align:right;vertical-align:bottom;}
      .ValueLineOverUnder {font-family:Arial;font-size:10pt;font-weight:normal;color:black;text-align:right;vertical-align:bottom;border-top:black thin solid;border-bottom:black thin solid}
      .ValueLineOver {font-family:Arial;font-size:10pt;font-weight:normal;color:black;text-align:right;vertical-align:bottom;border-top:black thin solid;}
      .Blank {visibility:hidden;}
     
   </style>
</head>
<body>
   <center>
   <table width='600' class='table' frame='none' rules='none' border='0' cellpadding='0' cellspacing='0'>
   <col width='600'/>
<tr>
    <td>
        <h1>IFRS Sample Company</h1>
    </td>
</tr>
<tr>
     <td  class='Heading'>Consolidated Balance Sheet</td>
</tr>
<tr>
     <td  class='Heading'>(at December 31, 2003)</td>
</tr>
<tr>
<td>
<table width='600' style='font-size:10pt' class='table' border='0' cellpadding='0' cellspacing='0'>
      <col width='500' />
      <col width='100' />
        <tr>
          <td colspan='1' style='text-align:Left'> </td>
          <td colspan='1' style='text-align:Right'>2003</td>
        </tr>
        <tr>
          <td colspan='1' style='text-align:Left'> </td>
          <td colspan='1' style='text-align:Right'>Euros</td>
        </tr>
 
      <tbody>

      <!-- Section -->
      <tr>
        <td colspan='3' class='SectionHeading'>ASSETS</td>
      </tr>

      <!-- Subsection -->
      <tr>
        <td colspan='3' class='SubSectionHeading'>Assets, Non Current</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Property, Plant and Equipment</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:PropertyPlantEquipmentNet,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Investment Property</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:InvestmentProperty,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Intangible Assets</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:IntangibleAssetsNet,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Biological Assets</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:BiologicalAssets,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Investments in Subsidiaries, at Cost</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:InvestmentsSubsidiariesCost,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Investments in Associates, at Cost</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:InvestmentsAssociatesCost,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Investments in Joint Ventures, at Cost</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:InvestmentsJointVenturesCost,'#,##0','base')" />
        </td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Investments in Associates, Equity Method</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:InvestmentsAssociatesEquityMethod,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Other Investments, Equity Method</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:OtherInvestmentsEquityMethod,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Investments Accounted for Using Equity Method</td>
        <td  class='ValueLineOverUnder'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:InvestmentsAccountedUsingEquityMethod,'#,##0','base')" />
        </td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Deferred Tax Assets</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:DeferredTaxAssets,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Other Financial Assets, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:OtherFinancialAssetsNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Hedging Instruments, Non Current [Asset]</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:HedgingInstrumentsNonCurrentAsset,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Trade and Other Receivables, Net, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:TradeOtherReceivablesNetNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Prepayments, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:PrepaymentsNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Cash Restricted or Pledged</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:CashRestrictedPledged,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Other Assets, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:OtherAssetsNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Assets, Non Current, Total</td>
        <td  class='ValueLineOverUnder'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:AssetsNonCurrentTotal,'#,##0','base')" />
        </td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>

      <!-- Subsection -->
      <tr>
        <td colspan='3' class='SubSectionHeading'>Assets, Current</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Assets Held for Sale</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:AssetsHeldSale,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Construction in Progress, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:ConstructionProgressCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Inventories</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:Inventories,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Construction in Progress, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:OtherFinancialAssetsCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Hedging Instruments, Current [Asset]</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:HedgingInstrumentsCurrentAsset,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Current Tax Receivables</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:CurrentTaxReceivables,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Trade and Other Receivables, Net, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:TradeOtherReceivablesNetCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Prepayments, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:PrepaymentsCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Cash and Cash Equivalents</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:CashCashEquivalents,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Other Assets, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:OtherAssetsCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Assets, Current, Total</td>
        <td  class='ValueLineOverUnder'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:AssetsCurrentTotal,'#,##0','base')" />
        </td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Assets, Total</td>
        <td  class='Value' style='border-bottom:black double solid'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:AssetsTotal,'#,##0','base')" />
        </td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>
      <!-- Section -->
      <tr>
        <td colspan='3' class='SectionHeading'>LIABILITIES AND EQUITY</td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>

      <!-- Section -->
      <tr>
        <td colspan='3' class='SectionHeading'>EQUITY</td>
      </tr>

      <!-- Section -->
      <tr>
        <td colspan='3' class='SubSectionHeading'>Equity, Parent</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Issued Capital</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:IssuedCapital,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Reserves</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:Reserves,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Treasury Shares</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:TreasuryShares * -1,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Retained Profits (Accumulated Losses)</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:RetainedProfitsAccumulatedLosses,'#,##0','base')" />
        </td>
      </tr>


      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Equity, Parent, Total</td>
        <td  class='ValueLineOver'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:EquityParentTotal,'#,##0','base')" />
        </td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>


      <!-- Line -->
      <tr>
        <td  class='Label'>Subscribed Capital</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:SubscribedCapital,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Minority Interest in Net Assets</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:MinorityInterestsNetAssets,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Equity Plus Minority Interest and Subscribed Capital, Total</td>
        <td  class='ValueLineOverUnder'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:EquityPlusMinorityInterestSubscribedCapitalTotal,'#,##0','base')" />
        </td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>

      <!-- Section -->
      <tr>
        <td colspan='3' class='SectionHeading'>LIABILITIES</td>
      </tr>

      <!-- Subsection -->
      <tr>
        <td colspan='3' class='SubSectionHeading'>Liabilities, Non Current</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Interest Bearing Borrowings, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:InterestBearingBorrowingsNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Non Interest Bearing Borrowings, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:NonInterestBearingBorrowingsNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Deferred Income, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:DeferredIncomeNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Provisions, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:ProvisionsNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Post Employment Benefit Obligation, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:PostEmploymentBenefitObligationNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Hedging Instruments, Non Current [Liability]</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:HedgingInstrumentsNonCurrentLiability,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Deferred Tax Liabilities</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:DeferredTaxLiabilities,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Trade and Other Payables, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:TradeOtherPayablesNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Other Liabilities, Non Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:OtherLiabilitiesNonCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Liabilities, Non Current, Total</td>
        <td  class='ValueLineOverUnder'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:LiabilitiesNonCurrentTotal,'#,##0','base')" />
        </td>
      </tr>

      <!-- Subsection -->
      <tr>
        <td colspan='3' class='SubSectionHeading'>Liabilities, Current</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Interest Bearing Borrowings, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:InterestBearingBorrowingsCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Non Interest Bearing Borrowings, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:NonInterestBearingBorrowingsCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Deferred Income, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:DeferredIncomeCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Provisions, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:ProvisionsCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Post Employment Benefit Obligation, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:PostEmploymentBenefitObligationCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Hedging Instruments, Current [Liability]</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:HedgingInstrumentsCurrentLiability,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Current Tax Payables</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:CurrentTaxPayables,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Trade and Other Payables, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:TradeOtherPayablesCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label'>Other Liabilities, Current</td>
        <td  class='Value'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:OtherLiabilitiesCurrent,'#,##0','base')" />
        </td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Liabilities, Current, Total</td>
        <td  class='ValueLineOverUnder'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:LiabilitiesCurrentTotal,'#,##0','base')" />
        </td>
      </tr>

      <!-- Blank line -->
      <tr>
        <td colspan='3' class='Blank'>*</td>
      </tr>

      <!-- Line -->
      <tr>
        <td  class='Label' style='text-indent:10pt;'>Liabilities and Equity, Total</td>
        <td  class='Value' style='border-bottom:black double solid'>
           <xsl:value-of select="format-number(/xbrli:xbrl/ifrs-gp:LiabilitiesEquityTotal,'#,##0','base')" />
        </td>
      </tr>






      </tbody>
 
      </table>
       <p style='height:5px'><span style='visibility:hidden'>-</span></p>
   </td>
</tr>
<tr>
     <td  style='font-family:Arial;font-size:10pt;font-weight:normal;color:black;text-align:left;vertical-align:bottom;padding-top:30px;'>
The accompanying notes form an integral part of the consolidated financial statements.
     </td>
</tr>
    </table>
    </center>
    </body>
</html>
</xsl:template>
</xsl:stylesheet>
